/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.restsec.jwt;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.token.Token;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.restsec.jwt.JwtException;
import oracle.security.restsec.jwt.SigningException;
import oracle.security.restsec.jwt.VerifyException;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class JwtToken
implements Token {
    private static final String EXPIRATION_TIME = "exp";
    private static final String ALGORITHM = "alg";
    private static final String AUDIENCE = "aud";
    private static final String ISSUED_AT = "iat";
    private static final String ISSUER = "iss";
    private static final String JSON_KEY_URL = "jku";
    public static final String JWT = "JWT";
    public static final String JWT_URI = "http://openid.net/specs/jwt/1.0";
    private static final String KEY_ID = "kid";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String SUBJECT = "sub";
    private static final String PRINCIPAL = "prn";
    private static final String TYPE = "typ";
    private static final String x509CERT_THUMBPRINT = "x5t";
    private static final String X509URL = "x5u";
    private static final String x509CERT_CHAIN = "x5c";
    private static final String CONTENT_TYPE = "cty";
    private static final String CRITICAL = "crit";
    private static final String JWT_ID = "jti";
    private Map<String, Object> claimSegment = new HashMap<String, Object>();
    private Map<String, Object> headerSegment = new HashMap<String, Object>();
    private String decodedHeaderString;
    private String decodedClaimString;
    private String encodedClaimString;
    private String encodedHeaderString;
    private String encodedCryptoString;
    private static final HashMap<String, String> algNameMap = new HashMap();

    public static byte[] fromBase64url(String s) {
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Base64url string!");
            }
        }
        return Utils.fromBase64((String)s);
    }

    public static String toBase64url(byte[] data) {
        String s = Utils.toBase64((byte[])data, (boolean)false);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public JwtToken() {
        this.setAlgorithm(SIGN_ALGORITHM.none.toString());
    }

    public JwtToken(String jwtString) throws JwtException {
        String[] jwtToken = jwtString.split("\\.");
        try {
            if (!(jwtToken.length == 3 || jwtString.endsWith(".") && jwtToken.length == 2)) {
                throw new IllegalArgumentException("The JWT must contain two period (.) characters.");
            }
            this.encodedHeaderString = jwtToken[0];
            this.encodedClaimString = jwtToken[1];
            this.encodedCryptoString = jwtToken.length == 2 ? "" : jwtToken[2];
            this.decodedHeaderString = new String(JwtToken.fromBase64url(jwtToken[0]), "UTF-8");
            this.decodedClaimString = new String(JwtToken.fromBase64url(jwtToken[1]), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JwtException(e);
        }
        catch (IllegalArgumentException e) {
            throw new JwtException(e);
        }
        try {
            this.headerSegment = (Map)mapper.readValue(this.decodedHeaderString, Map.class);
            this.claimSegment = (Map)mapper.readValue(this.decodedClaimString, Map.class);
        }
        catch (JsonParseException e) {
            throw new JwtException(e);
        }
        catch (JsonMappingException e) {
            throw new JwtException(e);
        }
        catch (IOException e) {
            throw new JwtException(e);
        }
    }

    public String getAlgorithm() {
        return (String)this.headerSegment.get(ALGORITHM);
    }

    public String getAudience() {
        if (this.claimSegment.containsKey(AUDIENCE)) {
            Object objAud = this.claimSegment.get(AUDIENCE);
            if (objAud instanceof String) {
                return (String)objAud;
            }
            ArrayList audiences = (ArrayList)objAud;
            return (String)audiences.get(0);
        }
        return null;
    }

    public String[] getAudiences() {
        if (this.claimSegment.containsKey(AUDIENCE)) {
            Object objAud = this.claimSegment.get(AUDIENCE);
            if (objAud instanceof String) {
                return new String[]{(String)objAud};
            }
            ArrayList audiences = (ArrayList)objAud;
            return audiences.toArray(new String[audiences.size()]);
        }
        return null;
    }

    public String getJwtID() {
        if (this.claimSegment.containsKey(JWT_ID)) {
            return (String)this.claimSegment.get(JWT_ID);
        }
        return null;
    }

    public Object getClaimParameter(String claim) {
        return this.claimSegment.get(claim);
    }

    public Map<String, Object> getClaimParameters() {
        return this.claimSegment;
    }

    public Date getExpiryTime() {
        Object expTime = this.claimSegment.get(EXPIRATION_TIME);
        if (null == expTime) {
            return null;
        }
        return new Date(JwtToken.getDate(expTime));
    }

    public Object getHeaderParameter(String header) {
        return this.headerSegment.get(header);
    }

    public Map<String, Object> getHeaderParameters() {
        return this.headerSegment;
    }

    public String getIssuer() {
        return (String)this.claimSegment.get(ISSUER);
    }

    public Date getIssueTime() {
        Object issueTime = this.claimSegment.get(ISSUED_AT);
        if (null == issueTime) {
            return null;
        }
        return new Date(JwtToken.getDate(issueTime));
    }

    public URL getJsonKeyURL() throws MalformedURLException {
        String url = (String)this.headerSegment.get(JSON_KEY_URL);
        if (url != null && url.length() > 0) {
            return new URL(url);
        }
        return null;
    }

    public String getKeyID() {
        return (String)this.headerSegment.get(KEY_ID);
    }

    public String getPrincipal() {
        return (String)this.claimSegment.get(PRINCIPAL);
    }

    public String getSubject() {
        if (this.claimSegment.containsKey(SUBJECT)) {
            return (String)this.claimSegment.get(SUBJECT);
        }
        return null;
    }

    public String getType() {
        return (String)this.headerSegment.get(TYPE);
    }

    public byte[] getX509CertThumbprint() {
        String thumbPrint = (String)this.headerSegment.get(x509CERT_THUMBPRINT);
        if (thumbPrint != null && thumbPrint.length() > 0) {
            return JwtToken.fromBase64url(thumbPrint);
        }
        return null;
    }

    public String[] getX509CertificateChain() {
        if (this.headerSegment.containsKey(x509CERT_CHAIN)) {
            ArrayList certs = (ArrayList)this.headerSegment.get(x509CERT_CHAIN);
            return certs.toArray(new String[certs.size()]);
        }
        return null;
    }

    public URL getX509URL() throws MalformedURLException {
        String url = (String)this.headerSegment.get(X509URL);
        if (url != null && url.length() > 0) {
            return new URL(url);
        }
        return null;
    }

    public String getContentType() {
        if (this.headerSegment.containsKey(CONTENT_TYPE)) {
            return (String)this.headerSegment.get(CONTENT_TYPE);
        }
        return null;
    }

    public String[] getCriticalHeader() {
        if (this.headerSegment.containsKey(CRITICAL)) {
            ArrayList critHeaders = (ArrayList)this.headerSegment.get(CRITICAL);
            return critHeaders.toArray(new String[critHeaders.size()]);
        }
        return null;
    }

    private String parseToJSONBase64url(Map<String, Object> jsonObject) throws JwtException {
        String result = null;
        StringWriter json = new StringWriter();
        try {
            mapper.writeValue((Writer)json, jsonObject);
            result = JwtToken.toBase64url(json.toString().getBytes("UTF-8"));
        }
        catch (JsonGenerationException e) {
            throw new JwtException(e);
        }
        catch (JsonMappingException e) {
            throw new JwtException(e);
        }
        catch (IOException e) {
            throw new JwtException(e);
        }
        return result;
    }

    public String serializeUnsigned() throws JwtException {
        StringBuilder result = new StringBuilder();
        result.append(this.parseToJSONBase64url(this.headerSegment));
        result.append(".");
        result.append(this.parseToJSONBase64url(this.claimSegment));
        result.append(".");
        result.append("");
        return result.toString();
    }

    public void setAlgorithm(String algorithm) {
        this.headerSegment.put(ALGORITHM, algorithm);
    }

    public void setAudience(String audience) {
        this.claimSegment.put(AUDIENCE, new String[]{audience});
    }

    public void setAudiences(String[] audiences) {
        this.claimSegment.put(AUDIENCE, audiences);
    }

    public void setJwtID(String id) {
        this.claimSegment.put(JWT_ID, id);
    }

    public void setClaimParameter(String claimParameter, Object value) {
        this.claimSegment.put(claimParameter, value);
    }

    public void setExpiryTime(Date expiryTime) {
        this.claimSegment.put(EXPIRATION_TIME, expiryTime.getTime() / 1000L);
    }

    public void setExpiryTimeInMS(Date expiryTime) {
        this.claimSegment.put(EXPIRATION_TIME, expiryTime.getTime());
    }

    public void setHeaderParameter(String headerParameter, Object value) {
        this.headerSegment.put(headerParameter, value);
    }

    public void setIssuer(String issuer) {
        this.claimSegment.put(ISSUER, issuer);
    }

    public void setIssueTime(Date issueTime) {
        this.claimSegment.put(ISSUED_AT, issueTime.getTime() / 1000L);
    }

    public void setIssueTimeInMS(Date issueTime) {
        this.claimSegment.put(ISSUED_AT, issueTime.getTime());
    }

    public void setJsonKeyURL(URL jsonKeyURL) {
        this.headerSegment.put(JSON_KEY_URL, jsonKeyURL.toString());
    }

    public void setKeyID(String keyID) {
        this.headerSegment.put(KEY_ID, keyID);
    }

    public void setPrincipal(String principal) {
        this.claimSegment.put(PRINCIPAL, principal);
    }

    public void setSubject(String sub) {
        this.claimSegment.put(SUBJECT, sub);
    }

    public void setType(String type) {
        this.headerSegment.put(TYPE, type);
    }

    public void setX509CertThumbprint(X509Certificate cert) throws JwtException {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] sha1 = sha1Digester.digest(cert.getEncoded());
            if (sha1 != null && sha1.length > 0) {
                this.headerSegment.put(x509CERT_THUMBPRINT, JwtToken.toBase64url(sha1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new JwtException(e);
        }
        catch (CertificateEncodingException e) {
            throw new JwtException(e);
        }
    }

    public void setX509CertificateChain(String[] certs) {
        this.headerSegment.put(x509CERT_CHAIN, certs);
    }

    public void setX509URL(URL x509url) {
        this.headerSegment.put(X509URL, x509url.toString());
    }

    public void setContentType(String contentType) {
        this.headerSegment.put(CONTENT_TYPE, contentType);
    }

    public void setCritical(String[] crit) {
        if (crit != null && crit.length > 0) {
            this.headerSegment.put(CRITICAL, crit);
        }
    }

    public String signAndSerialize(byte[] secret) throws SigningException, JwtException {
        String algo = this.getAlgorithm();
        if (algo == null || algo.isEmpty()) {
            throw new SigningException("Signature algorithm is missing.");
        }
        String jwtCryptoSegment = "";
        StringBuilder inputToSign = new StringBuilder();
        inputToSign.append(this.parseToJSONBase64url(this.headerSegment));
        inputToSign.append(".");
        inputToSign.append(this.parseToJSONBase64url(this.claimSegment));
        String jceAlgo = algNameMap.get(algo);
        try {
            if (jceAlgo == null || jceAlgo.isEmpty()) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm:- " + algo);
            }
            Mac mac = Mac.getInstance(jceAlgo);
            mac.init(new SecretKeySpec(secret, jceAlgo));
            mac.update(inputToSign.toString().getBytes("UTF-8"));
            byte[] macBytes = mac.doFinal();
            jwtCryptoSegment = JwtToken.toBase64url(macBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SigningException(e);
        }
        catch (InvalidKeyException e) {
            throw new SigningException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SigningException(e);
        }
        inputToSign.append(".");
        inputToSign.append(jwtCryptoSegment);
        return inputToSign.toString();
    }

    public String signAndSerialize(PrivateKey privateKey) throws SigningException, JwtException {
        String algo = this.getAlgorithm();
        if (algo == null || algo.isEmpty()) {
            try {
                throw new NoSuchAlgorithmException("Signature algorithm is missing.");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SigningException(e);
            }
        }
        String jwtCryptoSegment = "";
        StringBuilder inputToSign = new StringBuilder();
        inputToSign.append(this.parseToJSONBase64url(this.headerSegment));
        inputToSign.append(".");
        inputToSign.append(this.parseToJSONBase64url(this.claimSegment));
        String jceAlgo = algNameMap.get(algo);
        try {
            if (jceAlgo == null || jceAlgo.isEmpty()) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm:- " + algo);
            }
            Signature sig = CryptoUtils.getSignatureInstance((String)jceAlgo, (Key)privateKey);
            sig.initSign(privateKey);
            sig.update(inputToSign.toString().getBytes("UTF-8"));
            byte[] sigBytes = sig.sign();
            jwtCryptoSegment = JwtToken.toBase64url(sigBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SigningException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SigningException(e);
        }
        catch (InvalidKeyException e) {
            throw new SigningException(e);
        }
        catch (SignatureException e) {
            throw new SigningException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SigningException(e);
        }
        inputToSign.append(".");
        inputToSign.append(jwtCryptoSegment);
        return inputToSign.toString();
    }

    public String toString() {
        String header = null;
        String claims = null;
        try {
            header = this.decodedHeaderString != null ? this.decodedHeaderString : new String(JwtToken.fromBase64url(this.parseToJSONBase64url(this.headerSegment)));
            claims = this.decodedClaimString != null ? this.decodedClaimString : new String(JwtToken.fromBase64url(this.parseToJSONBase64url(this.claimSegment)));
        }
        catch (JwtException jwtException) {
            // empty catch block
        }
        return "JWT:-\nHeader Segment:-\n" + header + "\nClaim Segment:-\n" + claims;
    }

    public boolean verify(byte[] secret) throws VerifyException {
        boolean result = false;
        String algo = this.getAlgorithm();
        if (algo == null || algo.isEmpty()) {
            try {
                throw new NoSuchAlgorithmException("Signature algorithm is missing");
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyException(e);
            }
        }
        if (!SIGN_ALGORITHM.none.toString().equals(algo) || !this.encodedCryptoString.isEmpty()) {
            try {
                String jceAlgo = algNameMap.get(algo);
                if (jceAlgo == null || jceAlgo.isEmpty()) {
                    throw new NoSuchAlgorithmException("Unknown signature algorithm " + algo);
                }
                Mac mac = Mac.getInstance(jceAlgo);
                mac.init(new SecretKeySpec(secret, jceAlgo));
                StringBuilder inputToSign = new StringBuilder();
                inputToSign.append(this.encodedHeaderString);
                inputToSign.append(".");
                inputToSign.append(this.encodedClaimString);
                mac.update(inputToSign.toString().getBytes("UTF-8"));
                byte[] macBytes = mac.doFinal();
                result = Utils.areEqual((byte[])macBytes, (byte[])JwtToken.fromBase64url(this.encodedCryptoString));
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyException(e);
            }
            catch (InvalidKeyException e) {
                throw new VerifyException(e);
            }
            catch (IllegalStateException e) {
                throw new VerifyException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new VerifyException(e);
            }
        }
        return result;
    }

    public boolean verify(PublicKey publicKey) throws VerifyException {
        boolean result = false;
        String algo = this.getAlgorithm();
        if (algo == null || algo.isEmpty()) {
            try {
                throw new NoSuchAlgorithmException("Signature algorithm is missing");
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyException(e);
            }
        }
        if (!SIGN_ALGORITHM.none.toString().equals(algo) || !this.encodedCryptoString.isEmpty()) {
            try {
                String jceAlgo = algNameMap.get(algo);
                if (jceAlgo == null || jceAlgo.isEmpty()) {
                    throw new NoSuchAlgorithmException("Unknown signature algorithm " + algo);
                }
                StringBuilder inputToSign = new StringBuilder();
                inputToSign.append(this.encodedHeaderString);
                inputToSign.append(".");
                inputToSign.append(this.encodedClaimString);
                Signature sig = CryptoUtils.getSignatureInstance((String)jceAlgo, (Key)publicKey);
                sig.initVerify(publicKey);
                byte[] signatureBytes = JwtToken.fromBase64url(this.encodedCryptoString);
                sig.update(inputToSign.toString().getBytes("UTF-8"));
                result = sig.verify(signatureBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyException(e);
            }
            catch (NoSuchProviderException e) {
                throw new VerifyException(e);
            }
            catch (InvalidKeyException e) {
                throw new VerifyException(e);
            }
            catch (SignatureException e) {
                throw new VerifyException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new VerifyException(e);
            }
        }
        return result;
    }

    public boolean verify() throws VerifyException {
        boolean result = false;
        String algo = this.getAlgorithm();
        if (algo == null || algo.isEmpty()) {
            try {
                throw new NoSuchAlgorithmException("Signature algorithm is missing");
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyException(e);
            }
        }
        if (!SIGN_ALGORITHM.none.toString().equals(algo) || !this.encodedCryptoString.isEmpty()) {
            try {
                String jceAlgo = algNameMap.get(algo);
                if (jceAlgo == null || jceAlgo.isEmpty()) {
                    throw new NoSuchAlgorithmException("Unknown signature algorithm " + algo);
                }
                ArrayList certs = (ArrayList)this.headerSegment.get(x509CERT_CHAIN);
                if (certs == null || certs.size() == 0) {
                    throw new VerifyException("x5c certificate chain claim is missing");
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(Utils.fromBase64((String)((String)certs.get(0)))));
                StringBuilder inputToSign = new StringBuilder();
                inputToSign.append(this.encodedHeaderString);
                inputToSign.append(".");
                inputToSign.append(this.encodedClaimString);
                Signature sig = CryptoUtils.getSignatureInstance((String)jceAlgo, (Key)cert.getPublicKey());
                sig.initVerify(cert.getPublicKey());
                byte[] signatureBytes = JwtToken.fromBase64url(this.encodedCryptoString);
                sig.update(inputToSign.toString().getBytes("UTF-8"));
                result = sig.verify(signatureBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyException(e);
            }
            catch (NoSuchProviderException e) {
                throw new VerifyException(e);
            }
            catch (InvalidKeyException e) {
                throw new VerifyException(e);
            }
            catch (SignatureException e) {
                throw new VerifyException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new VerifyException(e);
            }
            catch (CertificateException e) {
                throw new VerifyException(e);
            }
        }
        return result;
    }

    private static long getDate(Object time) {
        long date = -1L;
        date = time instanceof Long ? ((Long)time).longValue() : ((Integer)time).longValue();
        int numDigit = Long.toString(date).length();
        if (numDigit < 13) {
            date *= 1000L;
        }
        return date;
    }

    static {
        algNameMap.put(SIGN_ALGORITHM.HS256.toString(), "HmacSHA256");
        algNameMap.put(SIGN_ALGORITHM.HS384.toString(), "HmacSHA384");
        algNameMap.put(SIGN_ALGORITHM.HS512.toString(), "HmacSHA512");
        algNameMap.put(SIGN_ALGORITHM.RS256.toString(), "SHA256withRSA");
        algNameMap.put(SIGN_ALGORITHM.RS384.toString(), "SHA384withRSA");
        algNameMap.put(SIGN_ALGORITHM.RS512.toString(), "SHA512withRSA");
        algNameMap.put(SIGN_ALGORITHM.ES256.toString(), "SHA256withECDSA");
        algNameMap.put(SIGN_ALGORITHM.ES384.toString(), "SHA384withECDSA");
        algNameMap.put(SIGN_ALGORITHM.ES512.toString(), "SHA512withECDSA");
    }

    public static enum SIGN_ALGORITHM {
        none,
        RS256,
        RS384,
        RS512,
        ES256,
        ES384,
        ES512,
        HS256,
        HS384,
        HS512;

    }
}

